import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;


public class Car {
   public static int width = 60;
   public static int height = width/2;
   
   private int xLeft;
   private int yTop;
   
   public Car(int x, int y){
      this.xLeft = x;
      this.yTop = y;
   }

   public void draw(Graphics2D g2) {
      int cH = height/3; // component height
      Rectangle body = new Rectangle(xLeft, yTop+cH,
                                     width, cH);
      Ellipse2D.Double frontTire =
         new Ellipse2D.Double(xLeft+cH, yTop+2*cH,
                              cH, cH);
      Ellipse2D.Double rearTire =
         new Ellipse2D.Double(xLeft+4*cH, yTop+2*cH,
                              cH, cH);
      Point2D.Double w1 = new Point2D.Double(xLeft+cH, yTop+cH);
      Point2D.Double w2 = new Point2D.Double(xLeft+2*cH, yTop);
      Point2D.Double w3 = new Point2D.Double(xLeft+4*cH, yTop);
      Point2D.Double w4 = new Point2D.Double(xLeft+5*cH, yTop+cH);
      Line2D.Double frontWindshield = new Line2D.Double(w1, w2);
      Line2D.Double top = new Line2D.Double(w2, w3);
      Line2D.Double rearWindshield = new Line2D.Double(w3, w4);
      
      Shape [] parts = {body, frontTire, rearTire, frontWindshield, top, 
                        rearWindshield};
      for (Shape s : parts)
         g2.draw(s);      
   }
   

}
